﻿package {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	
	public class FileUploadProgessWindow extends MovieClip{
		public var filename:String = "";
		public var percent:Number = 0;		
		public var dispatcher:EventDispatcher = new EventDispatcher();
		
		/* view variables:
			mc_total
			mc_part
			txtFilename
			txtPercent
			mc_cancelButton
			txtFailMessage
			txtSuccessMessage
			txtTopLine
		*/
		
		//constructor:
		public function FileUploadProgessWindow(){
			resetView();
			mc_cancelButton.addEventListener(MouseEvent.MOUSE_UP, cancelButtonClick);
		}
		
		//-----------------------------------------------
		// send parent event of canceling upload operation.
		public function cancelButtonClick(event:MouseEvent){
			dispatcher.dispatchEvent(new Event("uploadCancelClick"));
		}
		
		//-----------------------------------------------
		
		public function setFilename(filename:String){
			this.filename = filename;
		}
		
		//-----------------------------------------------
		// set percent by total and part
		public function setPercent(total,part){
			this.percent = Math.ceil(part/total*100);
		}

		//-----------------------------------------------
		// set percent by total and part
		public function setPercentNumber(num){
			this.percent = num;
		}


		//-----------------------------------------------
		// updates uploader view
		public function updateView(){
			this.txtFilename.text = this.filename;
			this.txtPercent.text = String(this.percent)+"%";
			if(percent == 0) this.mc_part.visible = false;
			else{
				mc_part.width = mc_total.width*percent/100;
				mc_part.visible = true;
			}
			setViewInitSettings();
		}
		
		//-----------------------------------------------
		// set view init settings (after add child on parent)
		public function setViewInitSettings(){
			var format:TextFormat = new TextFormat();
			format.align = TextFormatAlign.CENTER;
			this.txtTopLine.setTextFormat(format);
		}
		
		//-----------------------------------------------
		// reset the view
		public function resetView(){
			this.mc_part.visible = false;
			this.txtFilename.text = "";
			this.txtPercent.text = "";
			this.txtSuccessMessage.visible = false;
			this.txtFailMessage.visible = false;
			this.txtTopLine.visible = false;
		}
				
		//-----------------------------------------------
		// set success message
		public function setSuccessMessage(text){
			this.txtSuccessMessage.visible = true;
			this.txtFailMessage.visible = false;
			this.txtSuccessMessage.text = text;
			this.txtTopLine.visible = false;
		}
		
		//-----------------------------------------------
		// set fail message
		public function setFailMessage(text){
			this.txtFailMessage.visible = true;
			this.txtSuccessMessage.visible = false;
			this.txtFailMessage.text = text;
			this.txtTopLine.visible = false;
		}
		
		//-----------------------------------------------
		// set top line text, hide success and error messages.
		function setTopLineText(text){
			this.txtFailMessage.visible = false;
			this.txtSuccessMessage.visible = false;
			this.txtTopLine.text = text;
			this.txtTopLine.visible = true;
		}
		
	}
}